<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format">
 
 <xsl:template match="/">
  <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <fo:layout-master-set>
        <fo:simple-page-master master-name="main"
            page-height="29.7cm"
            page-width="21cm"
            margin-top="1cm"
            margin-bottom="1.5cm"
            margin-left="2.5cm"
            margin-right="1.5cm"
	    >
            <fo:region-body margin-top="1cm" 
            	margin-bottom="1.5cm" 
            	column-count="1" 
            	column-gap="0.25in"/>
            <fo:region-before extent="3cm"/>
            <fo:region-after extent="1.5cm"/>
        </fo:simple-page-master>
    </fo:layout-master-set>
       <fo:page-sequence master-reference="main">     
            <fo:flow flow-name="xsl-region-body">
             <xsl:apply-templates />
	</fo:flow>
    </fo:page-sequence>
  </fo:root>
 </xsl:template>

<xsl:template match="resumes|resume|location|date|from|to"><xsl:apply-templates/></xsl:template>

<xsl:template match="header">
<xsl:apply-templates select="name" /> 
	
<fo:table width="16cm" table-layout="fixed" 
	border-collapse="separate" >
	
		<fo:table-column column-number="1" column-width="3cm" >
	  	</fo:table-column>
		<fo:table-column column-number="2" column-width="85mm">
		</fo:table-column>
		<fo:table-column column-number="3" column-width="48mm">
		</fo:table-column>
		<fo:table-body>
		<fo:table-row>
   <fo:table-cell column-number="1" display-align="before">
<xsl:apply-templates mode="label" select="birth"/>
<xsl:apply-templates select="../misc" mode="label"/>
<xsl:apply-templates select="contact" mode="label" />		
<xsl:apply-templates select="address" mode="label" />		
   </fo:table-cell>
   <fo:table-cell column-number="2" display-align="before">
<xsl:apply-templates select="birth"/>
<xsl:apply-templates select="../misc" mode="header"/>
	<xsl:apply-templates select="contact"/>		
<xsl:apply-templates select="address"/>		
   </fo:table-cell>
   <fo:table-cell column-number="3" display-align="before">
<xsl:apply-templates select="/resumes/resume/misc/para/url" mode="photo"/>
</fo:table-cell>
 </fo:table-row>			
		</fo:table-body>
	</fo:table>
</xsl:template>


<xsl:template match="name">

    <fo:block font-size="18pt" text-align="center" 
    space-after="8mm" width="16cm" font-family="Trebuchet MS">
	<xsl:value-of select="title"/> 
	<xsl:text> </xsl:text>
	<xsl:value-of select="firstname"/> 
	<xsl:text> </xsl:text>
	<xsl:value-of select="surname"/>

</fo:block>
</xsl:template>

<xsl:template mode="label" match="birth">
	<fo:block font-style="italic" font-family="Trebuchet MS">
		Born:
      </fo:block>
</xsl:template>

<xsl:template match="birth">
	<fo:block font-family="Trebuchet MS">
		<xsl:apply-templates/>
      </fo:block>
</xsl:template>

<xsl:template match="dayOfMonth|month"><xsl:value-of select="."/>.</xsl:template>

<xsl:template match="city|country|state">, <xsl:value-of select="."/></xsl:template>

<xsl:template match="year"><xsl:value-of select="."/></xsl:template>

<xsl:template match="misc" mode="label">                                               
<xsl:apply-templates mode="label"/>                                                    
</xsl:template>  

<xsl:template match="para" mode="label">                                               
<xsl:if test="not(url)">
<fo:block font-style="italic" font-family="Trebuchet MS">               
<xsl:value-of select="emphasis"/>:
</fo:block>
</xsl:if>                                                                               
</xsl:template>  

<xsl:template match="misc" mode="header">                                               
<xsl:apply-templates mode="header"/>                                                    
</xsl:template>  

<xsl:template match="para" mode="header">                                               
<xsl:if test="not(url)">
<fo:block font-family="Trebuchet MS">                                   
<xsl:value-of select="text()"/>
</fo:block>                                                               
</xsl:if>                                                                               
</xsl:template>  


<xsl:template match="contact" mode="label"><xsl:apply-templates mode="label"/></xsl:template>       
<xsl:template match="contact"><xsl:apply-templates mode="header"/></xsl:template>       
                                                                                        
<xsl:template match="email" mode="label">                                              
	<fo:block font-style="italic" font-family="Trebuchet MS">
E-mail:
</fo:block>
</xsl:template>

<xsl:template match="email" mode="header">
<fo:block>
<fo:basic-link color="blue"  text-decoration="underline" >
	<xsl:attribute name="external-destination">mailto:<xsl:value-of select="."/></xsl:attribute>
	<xsl:value-of select="."/>
</fo:basic-link>
</fo:block>
</xsl:template>

<xsl:template match="url" mode="label">                                              
	<fo:block font-style="italic" font-family="Trebuchet MS">
Web:
</fo:block>
</xsl:template>

<xsl:template match="url" mode="header">                                              
<fo:block>
<fo:basic-link color="blue"  text-decoration="underline" 
external-destination="{.}">
	<xsl:value-of select="."/>
</fo:basic-link>
</fo:block>
</xsl:template>
                                    

<xsl:template match="fax" mode="label">                                                
<fo:block font-style="italic" font-family="Trebuchet MS">
Fax:
</fo:block>
</xsl:template>

<xsl:template match="fax" mode="header"> 
<fo:block font-family="Trebuchet MS">
<xsl:value-of select="."/>                                                              
</fo:block>
</xsl:template>
                                                                
<xsl:template match="phone" mode="label">                                              
<fo:block font-style="italic" font-family="Trebuchet MS">
<xsl:value-of select="@location"/>:
</fo:block>
</xsl:template>

<xsl:template match="phone" mode="header">
<fo:block font-family="Trebuchet MS">
<xsl:value-of select="."/>                                                              
</fo:block>
</xsl:template>

<xsl:template  match="address" mode="label">
	<fo:block font-style="italic">
		mail: 
      </fo:block>
</xsl:template>

<xsl:template  match="address">
	<fo:block>
		<xsl:value-of select="street"/>,
	</fo:block>
	<fo:block>	 
		<xsl:value-of select="zip"/>
		<xsl:text> </xsl:text> 
		<xsl:value-of select="city"/>, 
		<xsl:value-of select="country"/> 
      </fo:block>
</xsl:template>
                                                                                        
<xsl:template match="objective/para">
	<fo:block space-before="5mm">
	<fo:inline font-weight="bold" >
		Objective:
	</fo:inline>
		<xsl:value-of select="."/>  
</fo:block>
</xsl:template>

<xsl:template match="skillarea[position()=1]">
	<fo:block space-before="8mm" font-weight="bold" >
		<xsl:value-of select="title"/>:
	</fo:block>
	<xsl:apply-templates select="skillset" mode="headlines"/>
</xsl:template>

<xsl:template match="skillset" mode="headlines" >                                       
<fo:list-block provisional-distance-between-starts="15mm"
  		provisional-label-separation="5mm" >
		<xsl:apply-templates mode="headlines"/>
	</fo:list-block>                                                   
</xsl:template>    

<xsl:template match="skill" mode="headlines">
  <fo:list-item>
    <fo:list-item-label start-indent="5mm" end-indent="label-end()">
      <fo:block>
		-
      </fo:block>
    </fo:list-item-label>
    <fo:list-item-body start-indent="body-start()">
      <fo:block>
		<xsl:value-of select="."/>  
      </fo:block>
    </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="skillarea">
	<fo:block space-before="8mm" space-after="3mm"  font-weight="bold" font-family="Trebuchet MS">
		<xsl:value-of select="title"/>: 
	</fo:block>
        <fo:block font-family="Trebuchet MS">
		<fo:table width="16cm" table-layout="fixed" border-collapse="separate">
  			<fo:table-column column-number="1" column-width="27mm" >
  			</fo:table-column>
  			<fo:table-column column-number="2" column-width="133mm">
  			</fo:table-column>
  			<fo:table-body>   			
				<xsl:apply-templates/>
  			</fo:table-body>
		</fo:table>
        </fo:block>
</xsl:template>

<xsl:template match="skillset">
<fo:table-row>
   <fo:table-cell column-number="1" display-align="before" font-style="italic">
	<fo:block font-weight="bold" >
		 <xsl:value-of select="title"/>: 
      </fo:block>
   </fo:table-cell>
   <fo:table-cell column-number="2" display-align="before">
	<fo:block>
		<xsl:apply-templates/>
      </fo:block>
   </fo:table-cell>
</fo:table-row>
</xsl:template>

<xsl:template match="skill">
<xsl:value-of select="."/>, 
</xsl:template>
<xsl:template match="skill[position()=last()]">
<xsl:value-of select="."/>.
</xsl:template>
<xsl:template match="skill[position()=last()-1]">
<xsl:value-of select="."/> and 
</xsl:template>

<xsl:template match="skillset[position()=last()]/skill[position()=last()]">
<xsl:value-of select="."/>. 
</xsl:template>

<xsl:template match="history">
	<fo:block space-before="8mm" space-after="3mm"  font-weight="bold" 
	keep-with-next.within-page="always">
	<xsl:if test="not(@targets)">Experience</xsl:if>	
	<xsl:value-of select="@targets"/>: 
	</fo:block>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="job">
<fo:block color="white">|</fo:block>
<fo:table width="16cm" table-layout="fixed" border-collapse="separate">
  <fo:table-column column-number="1" column-width="12cm">
  </fo:table-column>
  <fo:table-column column-number="2" column-width="4cm">
  </fo:table-column>
  <fo:table-body>
    <fo:table-row>
      <fo:table-cell column-number="1" text-align="left">
        <fo:block>
		<xsl:apply-templates select="employer"/>
		<xsl:apply-templates select="location"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell column-number="2" text-align="right">
		<fo:block >
    			<xsl:apply-templates select="period"/>
		</fo:block>
      </fo:table-cell>
    </fo:table-row>
  </fo:table-body>
</fo:table>
<fo:block font-weight="bold" font-style="italic" font-family="Trebuchet MS">
<xsl:apply-templates select="employer/emphasis" mode="company_desc"/>
</fo:block>
<fo:block font-family="Trebuchet MS">
<fo:inline text-decoration="underline">
	<xsl:value-of select="jobtitle"/>
</fo:inline>
<xsl:text> </xsl:text>
<xsl:apply-templates select="achievements"/>                                            
<xsl:apply-templates select="projects"/>  
</fo:block>
</xsl:template>

<xsl:template match="employer">
<xsl:text> </xsl:text>
<xsl:if test="url">
	<fo:basic-link text-decoration="underline" color="blue" font-weight="bold" >
		<xsl:attribute name="external-destination">http://<xsl:value-of select="url"/></xsl:attribute>
		<xsl:value-of select="citation"/>
	</fo:basic-link>
</xsl:if>
<xsl:if test="not(url)">
	<fo:inline font-weight="bold" >
		<xsl:value-of select="citation"/>
	</fo:inline>
</xsl:if>
</xsl:template>


<xsl:template match="period">                                                           
<xsl:apply-templates select="from"/>                                                    
 -                                                                                      
<xsl:apply-templates select="to"/>                                                      
</xsl:template> 

<xsl:template  match="present">present</xsl:template>

<xsl:template match="emphasis" mode="company_desc">                                                              
<xsl:value-of select="."/>                                                  
</xsl:template>   

<xsl:template match="achievements">                                                     
<xsl:text> </xsl:text>                                                                  
<xsl:value-of select="achievement"/>                                                    
</xsl:template> 

<xsl:template match="projects">
	<fo:list-block provisional-distance-between-starts="15mm"
  		provisional-label-separation="5mm" >
		<xsl:apply-templates/>
	</fo:list-block>
</xsl:template>

<xsl:template  match="project">
  <fo:list-item>
    <fo:list-item-label start-indent="5mm" end-indent="label-end()">
      <fo:block>
		-
      </fo:block>
    </fo:list-item-label>
    <fo:list-item-body start-indent="body-start()">
      <fo:block font-family="Trebuchet MS">
		<xsl:value-of select="text()"/>
		<xsl:if test="citation">                                                                
		<xsl:text> </xsl:text>
		(<xsl:apply-templates select="citation" mode="project" />)                            
		</xsl:if> 
      </fo:block>
    </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="citation" mode="project">                                          
<xsl:value-of select="."/>,                                                             
</xsl:template>                                                                         
<xsl:template match="citation[position()=last()]" mode="project">                       
<xsl:value-of select="."/>                                                              
</xsl:template>                                                                         
<xsl:template match="citation[position()=last()-1]" mode="project">                     
<xsl:value-of select="."/> and                                                          
</xsl:template>   

<xsl:template match="academics">
	<fo:block space-before="8mm" space-after="3mm"  font-weight="bold" 
	keep-with-next.within-page="always">
		Education: 
	</fo:block>
<fo:table width="16cm" table-layout="fixed" space-before="0mm" 
border-collapse="separate">
  <fo:table-column column-number="1" column-width="14cm">
  </fo:table-column>
  <fo:table-column column-number="2" column-width="2cm">
  </fo:table-column>
  <fo:table-body>
	<xsl:apply-templates/>
  </fo:table-body>
</fo:table>
</xsl:template>

<xsl:template match="degree">
    <fo:table-row>
      <fo:table-cell column-number="1" text-align="left">
        <fo:block>
		<fo:inline font-weight="bold" >
			<fo:inline text-decoration="underline">
				<xsl:value-of select="level"/> 
			</fo:inline>
			<xsl:text> </xsl:text>
			<xsl:value-of select="institution"/>
		</fo:inline>
		(  <xsl:value-of select="major"/> ) 
        </fo:block>
      </fo:table-cell>
      <fo:table-cell column-number="2" text-align="right">
		<fo:block >
    			<xsl:value-of select="date/year"/>
		</fo:block>
      </fo:table-cell>
    </fo:table-row>
</xsl:template>

<xsl:template match="interests">
<fo:block color="white">-</fo:block>
<fo:table width="16cm" table-layout="fixed" space-before="0mm" border-collapse="separate">
  <fo:table-column column-number="1" column-width="4cm">
  </fo:table-column>
  <fo:table-column column-number="2" column-width="12cm">
  </fo:table-column>
  <fo:table-body>
	<xsl:apply-templates/>
  </fo:table-body>
</fo:table>
</xsl:template>

<xsl:template match="interest">
    <fo:table-row>
      <fo:table-cell column-number="1" text-align="left">
        <fo:block>
		<fo:inline font-weight="bold" >
			<xsl:value-of select="title"/>:
		</fo:inline>
		<xsl:text> </xsl:text>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell column-number="2" text-align="left">
		<fo:block ><xsl:apply-templates select="description/para" mode="interest"/><xsl:value-of select="text()"/></fo:block>
      </fo:table-cell>
    </fo:table-row>
</xsl:template>

<xsl:template match="para" mode="interest">                                             
<xsl:value-of select="text()"/><xsl:apply-templates />,                                 
</xsl:template>                                                                         
                                                                                        
<xsl:template match="para[position()=last()]"  mode="interest">                         
<xsl:value-of select="text()"/><xsl:apply-templates />.                                 
</xsl:template>                                                                         
                                                                                        
<xsl:template match="link">
<fo:basic-link color="blue"  text-decoration="underline" >
	<xsl:attribute name="external-destination"><xsl:value-of select="@href"/></xsl:attribute>
	<xsl:value-of select="."/>
</fo:basic-link>
</xsl:template>  

<xsl:template match="text()">
</xsl:template>

</xsl:stylesheet>