<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >

<xsl:template match="/">
  <html>
    <head>
      <style>
body {font-family:'Trebuchet MS','Bookman Old Style','Futura Lt BT','Tahoma','Arial'; margin-right:1.5em}
.name {font-size:24px;text-align:center}
.tx {font-size:12px;text-align:left}
.i {font-style:italic}
.b {font-weight:bold;}
.ar {font-family:'Arial';font-size:14px;font-weight:bold;}
       </style>
 </head>
    <body><xsl:apply-templates/></body>
  </html>
</xsl:template>

<xsl:template match="resumes|resume|location|date|from|to"><xsl:apply-templates/></xsl:template>

<xsl:template match="header">
  <xsl:apply-templates select="name" />
    <div class="tx">
<table border="0" cellspacing="5" cellpadding="9" width="100%" ><tr><td>
<table border="0" cellspacing="0" cellpadding="0"  >
<xsl:apply-templates select="birth"/>
<xsl:apply-templates select="../misc" mode="header"/>
<xsl:apply-templates select="address"/>
<xsl:apply-templates select="contact"/>
</table>
</td>
<td align="right">
<img HEIGHT="150">
<xsl:attribute name="src"> 
<xsl:value-of select="../misc/para/url"/>
</xsl:attribute>
</img>
</td>
</tr>
</table>
</div>
</xsl:template>

<xsl:template match="name">
  <div class="name">
<xsl:value-of select="title"/> 
<xsl:text> </xsl:text>
<xsl:value-of select="firstname"/> 
<xsl:text> </xsl:text>
<xsl:value-of select="surname"/>
  </div>
</xsl:template>

<xsl:template match="birth">
<tr><td><span class="i">Born:</span></td><td>
<span style="margin-left:10px;"><xsl:apply-templates/></span>
</td></tr>
</xsl:template>

<xsl:template match="dayOfMonth|month"><xsl:value-of select="."/>.</xsl:template>

<xsl:template match="city|country|state">, <xsl:value-of select="."/></xsl:template>

<xsl:template match="year"><xsl:value-of select="."/></xsl:template>

<xsl:template match="misc" mode="header">
<xsl:apply-templates mode="header"/>
</xsl:template>

<xsl:template match="para" mode="header">
<xsl:if test="not(url)">
<tr><td><span class="i"><xsl:value-of select="emphasis"/>:</span></td><td><span style="margin-left:10px;">
<xsl:value-of select="text()"/></span>
</td></tr>
</xsl:if>
</xsl:template>

<xsl:template match="contact"><xsl:apply-templates mode="header"/></xsl:template>

<xsl:template match="email" mode="header">
<tr><td><span class="i">E-mail:</span></td><td>
<span style="margin-left:10px;">
<a>
<xsl:attribute name="href">maito:<xsl:value-of select="."/></xsl:attribute>
<xsl:value-of select="."/>
</a>
</span>
</td></tr>
</xsl:template>

<xsl:template match="url" mode="header">
<tr><td><span class="i">Web:</span></td><td>
<span style="margin-left:10px;">
<a>
<xsl:attribute name="href"><xsl:value-of select="."/></xsl:attribute>
<xsl:value-of select="."/>
</a>
</span>
</td></tr>
</xsl:template>

<xsl:template match="fax" mode="header">
<tr><td><span class="i">Fax:</span></td><td>
<span style="margin-left:10px;">
<xsl:value-of select="."/>
</span>
</td></tr>
</xsl:template>

<xsl:template match="phone" mode="header">
<tr><td><span class="i"><xsl:value-of select="@location"/>:</span></td><td>
<span style="margin-left:10px;">
<xsl:value-of select="."/>
</span>
</td></tr>
</xsl:template>

<xsl:template  match="address">
<tr><td><span class="i">mail: </span></td><td>
<span style="margin-left:10px;">
<xsl:value-of select="street"/>, 
<xsl:value-of select="zip"/>
<xsl:text> </xsl:text> 
<xsl:value-of select="city"/>, 
<xsl:value-of select="country"/>
</span> 
</td></tr>
</xsl:template>

<xsl:template match="objective/para">
<p>
<span class="b">Objective: </span>
<xsl:value-of select="."/>  
</p>
</xsl:template>

<xsl:template match="skillarea[position()=1]">
<p>
<span class="b"><xsl:value-of select="title"/>:</span> 
<xsl:apply-templates select="skillset" mode="headlines"/>
</p>
</xsl:template>

<xsl:template match="skillset" mode="headlines" >
<ul>
<xsl:apply-templates mode="headlines"/>
</ul>
</xsl:template>

<xsl:template match="skill" mode="headlines" >
<li>
<xsl:value-of select="."/>
</li>  
</xsl:template>

<xsl:template match="skillarea">
<span class="ar"><xsl:value-of select="title"/>: </span>
<table> 
<xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match="skillset">
<tr>
<td valign="top"> 
<span class="b"><xsl:value-of select="title"/></span>  
</td>
<td>
<xsl:apply-templates/>
</td>
</tr>
</xsl:template>

<xsl:template match="skill">
<xsl:value-of select="."/>, 
</xsl:template>
<xsl:template match="skill[position()=last()]">
<xsl:value-of select="."/>;
</xsl:template>
<xsl:template match="skill[position()=last()-1]">
<xsl:value-of select="."/> and 
</xsl:template>

<xsl:template match="skillset[position()=last()]/skill[position()=last()]">
<xsl:value-of select="."/>. 
</xsl:template>

<xsl:template match="history">
<p>
<span class="ar"><xsl:value-of select="@targets"/>: </span>
<xsl:apply-templates/>
</p>
</xsl:template>

<xsl:template match="CONSULTING">
<P>
<SPAN class="ar">Consulting and Fellowships: </SPAN>
<xsl:apply-templates/>
</P>
</xsl:template>

<xsl:template match="job">
<p>
<table border="0" width="100%">
<tr>
<td>
<xsl:apply-templates 
select="employer"/><xsl:apply-templates 
select="location"/>
</td>
<td  align="right">
<xsl:apply-templates select="period"/>
</td>
</tr>
</table>
<xsl:apply-templates select="employer/emphasis" mode="company_desc"/>
<u><xsl:value-of select="jobtitle"/></u>
<xsl:apply-templates select="achievements"/>
<xsl:apply-templates select="projects"/>
</p>
</xsl:template>

<xsl:template match="employer">
<xsl:text> </xsl:text>
<xsl:if test="url">
<a>
<xsl:attribute name="href">http://<xsl:value-of select="url"/></xsl:attribute>
<span class="b">
<xsl:value-of select="citation"/>
</span>
</a>
</xsl:if>
<xsl:if test="not(url)">
<span class="b">
<xsl:value-of select="citation"/>
</span>
</xsl:if>
</xsl:template>

<xsl:template match="period">
<xsl:apply-templates select="from"/>
 - 
<xsl:apply-templates select="to"/>
</xsl:template>

<xsl:template  match="present">present</xsl:template>

<xsl:template match="emphasis" mode="company_desc">
<span class="i">
<xsl:value-of select="."/><br/></span>
</xsl:template>

<xsl:template match="achievements">
<xsl:text> </xsl:text>
<xsl:value-of select="achievement"/>
</xsl:template>

<xsl:template match="projects">
<ul>
<xsl:apply-templates/>
</ul>
</xsl:template>

<xsl:template  match="project">
<li>
<xsl:value-of select="text()"/>
<xsl:if test="citation">
( <xsl:apply-templates select="citation" mode="project" /> )
</xsl:if>
</li>
</xsl:template>


<xsl:template match="citation" mode="project">
<xsl:value-of select="."/>, 
</xsl:template>
<xsl:template match="citation[position()=last()]" mode="project">
<xsl:value-of select="."/>
</xsl:template>
<xsl:template match="citation[position()=last()-1]" mode="project">
<xsl:value-of select="."/> and 
</xsl:template>

<xsl:template match="academics">
<p>
<span class="ar">Education: </span>
<xsl:apply-templates/>
</p>
</xsl:template>

<xsl:template match="degrees">
<table border="0" width="100%">
<xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match="degree">
<tr>
<td>
<span class="b">
<u><xsl:value-of select="level"/></u>
<xsl:text> </xsl:text>
 <xsl:value-of select="institution"/> 
</span>
(  <xsl:value-of select="major"/> )
</td>
<td>
 <xsl:value-of select="date/year"/>
</td>
</tr> 
</xsl:template>

<xsl:template match="interests">
<table border="0" width="100%">
<xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match="interest">
<tr>
<td valign="top">
<span class="b">
<xsl:value-of select="title"/>:
</span>
<xsl:text> </xsl:text>
</td>
<td>
<xsl:apply-templates select="description/para" mode="interest" />
</td>
</tr> 
</xsl:template>

<xsl:template match="para" mode="interest">
<xsl:value-of select="text()"/><xsl:apply-templates />,
</xsl:template>

<xsl:template match="para[position()=last()]"  mode="interest">
<xsl:value-of select="text()"/><xsl:apply-templates />.
</xsl:template>

<xsl:template match="link">
<a>
<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
<xsl:value-of select="."/>
</a>
</xsl:template>

<xsl:template match="text()"></xsl:template>

</xsl:stylesheet>